<?PHP
/**
* A template for any page that follows the standard inbox format in webmail (banner at the top, menu items underneath, sidebar with folders to the left of the main content).
*
* This is intended to be called using the {@link Template} library: 
*
* <code>
* //generates the content for the inbox/compose view using $data, and passes it to the template as the $contents variable
* $this->template->load('template', 'inbox/compose', $data);
* </code>
*
* The header markup has been altered slightly from the original header/header markup: the menu nav has been moved out of the #header div
* into .body-main so that the main body of the page can have a form that is independent of the search form in #header, but still contains the menu controls.
*
* Known issues:
* 	- Horizontal scrolling (viewport < 1000px) looks pretty weird with the fixed sidebar & menu; at minimum, it would be good to give the sidebar a background color, but that 
* 		interferes with the compose button background color in IE8.  Revisit this later. (Issue existed prior to Sprint 12).
* 	- Need to revisit min-width values overall: top nav starts collapsing before it hits its min width, inbox tables can't fit the full byte size at min width
*   - 
*
*
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

/* variables that should be passed to the template 
	$CI; //instance
	$page_title; //the name of the page, used in a hidden <h2> to indicate the page name to accessibility users
	$menu_partial; //the snippet of HTML used for the controls for this page */
if(empty($form_destination)) $form_destination = current_url(); //where the primary form on this page should go to on submission  
$theme_css = element('theme_css_name', $CI->user_theme);

$optional_vars = array( 'current_user' => '', 
						'display_name' => '',
						'json_mailbox_list' => '{}', 
						'mailboxes' => '',
						'other_members' => array(),
						'title' => '',
						'show_workflow' => false);

//make sure that optional vars all have a value
foreach( $optional_vars as $optional_var => $default_value){
	if(!isset($$optional_var)) $$optional_var = $default_value;
}

$user_feedback_message = $this->session->userdata('message');

if(!empty($_SESSION['unseen']) && $menu_partial == '_inbox_menu')
	$title .= ' ('.$_SESSION['unseen'].')';

?>
<!doctype html>
<html>
	<head>
		<title><?PHP echo $title;?></title>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta http-equiv="X-UA-Compatible" content="IE=edge" />
		<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon" />
		<link rel="icon" href="/favicon.ico" type="image/x-icon" />
		<link rel="stylesheet" type="text/css" href="/css/grids.css" />
		<link rel="stylesheet" type="text/css" href="/css/main.css" />
		<link rel="stylesheet" type="text/css" href="/css/jquery.lightbox-0.5.css" />
		<link rel="stylesheet" type="text/css" href="/css/custom-theme/jquery-ui-1.8.18.custom.css" />
		<link rel="stylesheet" type="text/css" href="/jscripts/fancybox/jquery.fancybox-1.3.4.css" media="screen" />
		<link rel="stylesheet" type="text/css" href="/css/tinyeditor.css" />
		<link rel="stylesheet" type="text/css" href="/css/token-input-dpii.css" />
		<link rel="stylesheet" href="/css/multiselect/common.css" type="text/css" />
		<link type="text/css" href="/css/multiselect/ui.multiselect.css" rel="stylesheet" />
		<link rel="stylesheet" href="/css/qtip/jquery.qtip.min.css" type="text/css" />
		<link rel="stylesheet" href="/css/qtip/jquery.qtip.css" type="text/css" />
		<link rel="stylesheet" href="/css/jquery.dropdown.css" type="text/css" />
		<link rel="stylesheet" href="/css/chosen.min.css" type="text/css" />
		<?PHP if(!empty($theme_css)) { echo '<link rel="stylesheet" type="text/css" href="/css/themes/' . $theme_css . '.css" />'; } ?>
		<script type="text/javascript" src="/jscripts/jquery.min.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.lightbox-0.5.min.js"></script>
		<script type="text/javascript" src="/jscripts/fancybox/jquery.fancybox-1.3.4.js"></script>
		<script type="text/javascript" src="/jscripts/fancybox/jquery.mousewheel-3.0.4.pack.js"></script>
		<script type="text/javascript" src="/jscripts/libraryfunctions.js"></script>
		<script type="text/javascript" src="/jscripts/headerfunctions.js"></script>
		<script type="text/javascript" src="/jscripts/helper.js"></script>
		<script type="text/javascript" src="/jscripts/jquery-ui-1.8.17.custom.min.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.jeditable.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.form.js"></script> 
		<script type="text/javascript" src="/jscripts/jquery.filedrop.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.autogrow.js"></script>
		<script type="text/javascript" src="/jscripts/tinyeditor.js"></script>
		<script type="text/javascript" src="/jscripts/ui.multiselect.js"></script>
		<script type="text/javascript" src="/jscripts/qtip/jquery.qtip.min.js"></script>
		<script type="text/javascript" src="/jscripts/qtip/jquery.qtip.js"></script>
		<script type="text/javascript" src="/jscripts/qtip/imagesloaded.pkg.min.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.dropdown.js"></script>
		<!-- View that displays jQuery message slideout whenever there is a user action performed.
			Uses jquery.noty.js library. 
			http://needim.github.com/noty/
		 -->
		<script type="text/javascript" src="/jscripts/noty/jquery.noty.js"></script>
		<script type="text/javascript" src="/jscripts/noty/layouts/top.js"></script>
		<script type="text/javascript" src="/jscripts/noty/layouts/topLeft.js"></script>
		<script type="text/javascript" src="/jscripts/noty/layouts/topRight.js"></script>
		<script type="text/javascript" src="/jscripts/noty/layouts/inline.js"></script>
		<script type="text/javascript" src="/jscripts/noty/themes/default.js"></script>
		<script type="text/javascript" src="/jscripts/noty/themes/inline.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.tokeninput.js"></script>
		<script type="text/javascript" src="/jscripts/chosen.jquery.min.js"></script>
		<style>	
<?php #TODO - MG, don't forget to move this to main.css, lose the debugging colors, and format it in a manner that ATB would approve of when you're done fiddling with it	?>
			.inbox-template { min-width: 962px; /* our responsive design doesn't really accomodate <1024px yet, so enforce that the screen remains that wide for now */ } 	
			.inbox-template #header { border-bottom: 0; /*background-color: turquoise; */ }
			.inbox-template #header_padding {   /* background-color: purple; */ }
			.inbox-template #messages { width: 100%; margin-right: 0; }
			.inbox-template #pagination { position: static; margin-right: 0; line-height: 23px; }	
							
			.inbox-template div.button.minimal{ display: inline-block; float: none; width: auto; height: auto; margin: 0; padding: 0 20px; }
			.inbox-template div.button.minimal a { display: inline; line-height: 27px; color: #333; text-shadow: rgb(238, 238, 238) 0px 1px 0px; }
			.inbox-template div.button.minimal.minimal-short a { line-height: 21px; }
			.inbox-template div.button.minimal.minimal-image { padding: 0; }
			.inbox-template div.button.minimal.minimal-image a { line-height: 2px;}		
			.inbox-template div.button.minimal.minimal-image img { height: 21px;}			
			
			.inbox-template .body {clear: both; position: static; margin: 0; padding: 0; border: 0; padding-left: 160px;  /* background-color: red; */ }
			.inbox-template .body .sidebar-left { position: fixed; top: 175px; display: block; float: left; width: 150px; margin:0 0 0 -150px; padding: 0; border: 0; /* background-color: #fff; */  /* background-color: orange; */ }
			.inbox-template .body .body-main { position: static; width: 98%; /* background-color: yellow; */ }
			
			/* note - although these fields are within body-main, they default to the full screen width because they're absolutely fixed.  so, we need to re-create the percentage widths applied to body-main */
			.inbox-template .body .body-main .menu { position: fixed; top: 130px; z-index: 100; width: 94%; min-width: 962px; margin: 0 0 0 -160px; padding: 0 0 5px 0; border-bottom: 1px solid #ddd; /*-webkit-box-shadow: rgb(153, 153, 153) 0px 4px 5px -2px; box-shadow: rgb(153, 153, 153) 0px 4px 5px -2px; */ background-color: #fff; /* background-color: green; */}
			.inbox-template .body .body-main .menu-wrap {  margin: 0; padding: 0 0 0 160px; border: 0; /* background-color: blue; */}
			.inbox-template .body .body-main .button-container { width: 98%; /* background-color: magenta; */ } 
			/* end absolutely fixed */
			
			.inbox-template .body .body-main .button-container .unit { /*background-color: pink; */}
			.inbox-template .body .body-main .button-container button.minimal-short { margin: 0 5px 0 0; padding: 5px 0; } 
			.inbox-template .body .body-main .button-container.compose-buttons button.minimal-image { padding: 2px; }
			.inbox-template .body .body-main .button-container.compose-buttons button.minimal-image img { height: 17px; }
				
		</style>
	</head>
	<body>
	<?php if($CI->session->userdata("is_loggedin") == "true") { echo $CI->load->view('options_bar', compact('CI', 'group_mailboxes', 'show_adminpanel_link'), TRUE); } ?>
	<div id="wrapper" class="inbox-template <?php echo make_string_css_friendly( get_class($CI).'-'.$CI->router->fetch_method() ) ?>">
		<?PHP  /*make sure csrf token is on the page for AJAX requests (GET as well as POST) */ /* is it a problem that this isn't actually in a form? */
			echo form_hidden($CI->security->get_csrf_token_name(),$CI->security->get_csrf_hash(),$CI->security->get_csrf_token_name(),'token'); 
		?>
		<?PHP 
			if($CI->session->userdata("just_logged_in")) {
				if(isset($first_login_message)) echo $first_login_message;
				$CI->session->set_userdata("just_logged_in",FALSE);
			}
		?>
		<div id="header" class="inbox line">
			<?PHP echo $CI->load->view('header/banner', array(), TRUE); ?>
            <a style="display: block; top: 0; width: 100px; height: 100px; position: absolute; font-size: 0; line-height: 0; color: transparent;" title="Inbox" href="/inbox">Logo and Link to Inbox</a>
		<?php if($CI->session->userdata("is_loggedin") == "true"): ?>
          	<div id="version_container"><?php echo 'Version ' . APPLICATION_BUILD_VERSION;?></div>
			<div id="search">
				<?PHP echo form_open_multipart("inbox/form_check"); ?>
					<?PHP echo form_label("Search Input","search_input",array("class" => "hidden_context")); ?>
                	<?PHP echo form_input(array("name" => "search_input","id" => "search_input", "style" => "")); ?>
                	<button class="minimal minimal-short" id="search_btn" name="search" type="submit" onClick="$(this).attr('clicked','true');">Search</button>
				<?php echo form_close(); ?>
            </div>
        <?php endif ?>
			<?php echo $CI->load->view('message_modal', compact('CI', 'feedback_message', 'feedback_class'), TRUE); ?>
			<?php echo $CI->load->view('disabled_service_notification', array('CI'), TRUE); ?>
		</div>
		<div id="header_padding"></div>
		<div class="body">
			<div class="folders-wrapper sidebar-left">
				<a name="mailboxListContent" id="mailboxListContent" class="hidden_context hidden_link">Mailbox List</a> 
				<a class="hidden_context hidden_link" href="#mainContent" id="skipMailboxList">Skip Mailbox List</a>
				<div class="folders">
					<button class="minimal minimal-short" type="button" id="compose_btn" onclick="document.location.href='<?PHP echo site_url('inbox/compose') ?>';"> Compose </button>
					<br/>
					<br/>
					<h2 class="hidden_context">Mailbox Folder Menu</h2>
					<?PHP echo $mailboxes;?> <a class="hidden_context hidden_link" href="#menuContent" id="skipToMenu">Skip to Menu</a> 
				</div>
			</div>
			<div class="body-main unit size1of1">
				<?PHP echo form_open_multipart($form_destination, array("id" => "main_form")); ?>
					<div class="menu line">		
						<a class="hidden_context hidden_link" name="menuContent" id="menuContent">Menu</a>
						<a class="hidden_context hidden_link" name="menuContent" id="skipMenu" href="#mailboxListContent">Skip Menu</a>			
						<div class="menu-wrap unit size1of1 line">
						<?php if(!empty($menu_partial)): ?>
							<?php echo $CI->load->view($menu_partial, compact('CI', 'folder_name', 'json_mailbox_list', 'message_count', 'other_members', 'page_start', 'show_workflow', 'total'), TRUE) ?>
						<?php endif ?>
						</div>
					</div>
					<?php if(!empty($user_feedback_message)) echo $user_feedback_message; ?>
					<a name="mainContent" id="mainContent" class="hidden_context hidden_link">Main Content</a>
					<h2 class="hidden_context"><?php echo $page_title ?></h2>		
					<div id="msg_pane"> 
						<?php if(!empty($search_message)): ?><h3><?php echo $search_message ?></h3><?php endif ?>
						<?php echo $contents ?> 
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
	<?PHP echo $CI->load->view('footer', array(), TRUE);  ?>
	<div id="pros_modal"  style="height: 100px; width: 300px; display: none;">
		<p style="text-align: center; ">Processing Request...</p>
		<img src="/images/ajax-loader-large.gif" alt="Processing..." style="display: block; margin-top: 10px; margin-right: auto; margin-left: auto;" />
	</div>
	<script type="text/javascript">
		$(document).ready(function(){
			var lastLeft = -1,
			menu = $('#mailbox_wrapper, #header');
	
			$('#mailbox_wrapper').css('position', 'absolute');
			$(window).on('scroll resize', function(){
				var totalWidth = $('#wrapper').css('width').slice(0,-2);
				if (totalWidth > window.innerWidth) {
					$('#header').css('margin-left', '3%');
					var left = $(window).scrollLeft();
					if (left >= 0 && left!==lastLeft){
						lastLeft = left;
						menu.css('left',-left+'px');
					}
				}
			});
		});
	</script>	
</body>
</html>